package keepoutbot;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Armor;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.Extra;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
    
    boolean hit, // indikuje ze me nekdo strelil
            init = true; // startuje raycasting
    int health_level = 70, // hranice, kde uz ma smysl shanet lekarnu
        strafe, // pocet cyklu ktere uz ubiham jednim smerem
        look, // pocet cyklu ktere shanim jednu vec
        find_med = 0; // pocet cyklu kdy shanim lekarnu
    Player enemy; // cil, ktereho je treba se bat :o)
    public ArrayList<Item> medkitToRun; // shanim postupne tyto lekarny
    Triple MARK, // bod, kam zrovna utikam pred strelbou
           hide_position, // pozice kam se muzu schovat
           drive, // bod dalsi lekarny
           direction; // bod dalsiho equipmentu
    protected RayTraces traces = new RayTraces(); // paprsky
    
    public enum Ray {
        /** 30 stupnu nalevo*/
        LEFT30_1000(1, new Triple(1, 2, 0), 1000),
        /** 90 stupnu nalevo */
        LEFT90_1000(2, new Triple(0, 1, 0), 1000),
        /** 30 stupnu napravo */
        RIGHT30_1000(3, new Triple(1, -2, 0), 1000),
        /** 90 stupnu napravo */
        RIGHT90_1000(4, new Triple(0, -1, 0), 1000);
        
        private int id;
        private Triple vector;
        private double length;
        
        private Ray(int id, Triple vector, double length) {
            this.id = id;
            this.vector = vector;
            this.length = length;
        }
        
        public int getId() {
            return id;
        }
        
        public Triple getVector() {
            return vector;
        }
        
        public double getLength() {
            return length;
        }
        
    }
    
    /**
     * Next we will declare an inner class that will take care of the traces.
     * It will listen on the ATR messages and write them to it's map (therefore
     * it implements RcvMsgListener).
     * 
     * tohle je ukradene z raycasting bota
     */
        protected class RayTraces implements RcvMsgListener {
        
        public RayTraces() {            
        }
        
        private Map<Integer, AutoTraceRay> traces = new HashMap<Integer, AutoTraceRay>();
        
        /**
         * This method will be called from doLogic() only once to initialize the object.
         */
        public void botInit() {
            log.info("RayTraces.botInit(): called");
            
            // tells the GameBots we want autotracing
            bot.getBody().startAutoTrace();
            
            // remove default auto trace rays
            bot.getBody().removeAllRaysFromAutoTrace();
            
            // now 1) register every ray inside GameBots and
            //     2) create initial value for every ray
            for (Ray ray : Ray.values()) {
                bot.getBody().addRayToAutoTrace(ray.getId(), ray.getVector(), ray.getLength(), 
                                       false, // whether this is FastTrace ... NO we want full trace
                                              // to get HitNormal informations
                                       false  // whether we should trace the players and helaths as well
                                              // NO ... we want only walls, floors, etc.
                                      );
                traces.put(ray.getId(), new AutoTraceRay());
            }
            
            // register itself as a listener for ATR messages, so 
            // we can catch the AUTO_TRACE_RAY
            bot.getBody().addTypedRcvMsgListener(this, MessageType.AUTO_TRACE_RAY);
            
            // now a little workarounds ...
            
            // we have to move a bot a bit to get first readings from rays
            bot.getBody().moveInch();
            
            // now, to see only new rays (not the default ones), we have to switch
            // visibility of autotraces off and on again (with little delay)
            bot.getBody().configureAutoTrace(false);
            try {
                Thread.sleep(200);
            } catch (InterruptedException ex) {               
            }
            bot.getBody().configureAutoTrace(true);

        }

        /**
         * In this method we're receiving notices about ATR messages. It's
         * called every time when ATR message arrives.
         * @param e
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            // get the message from the event (casting it properly)
            AutoTraceRay ray = (AutoTraceRay)e.getMessage();
            try {
                // be synchronized with 'traces' to prevent concurrent read/write operations
                synchronized(traces) {
                    // insert the ray under it's number
                    // notice that ID goes under UnrealID field in the 'ray'
                    traces.put(Integer.parseInt(ray.UnrealID), ray);
                }
            } catch (Exception ex) {
                log.severe(ex.getMessage());
            }
        }
        
        //
        // now follows methods for getting the traces out of the object
        // 
        
        /**
         * Returns info about one ray.
         * @param ray
         * @return
         */
        public AutoTraceRay getTrace(Ray ray) {
            synchronized(traces) {
                return traces.get(ray.getId());
            }            
        }
        
        /**
         * Returns the copy of the map of traces.
         * 
         * This will be useful for you when you will program the
         * control mechanism of the bot. You shouldn't rely on the getTrace()
         * because two calls of it may return different result (because of 
         * a two thread design of the bot).
         * 
         * @return current state of traces
         */
        public Map<Integer, AutoTraceRay> getTraceSnapshot() {
            synchronized(traces) {
                return new HashMap<Integer, AutoTraceRay>(traces);
            }
        }
        
    }
    
    
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
    }
    
    /**
     * zdravi kleslo pod unosnou miru
     * - najde nejblizsi medkit a priradi ho jako cil
     * @return
     */
    public boolean sense_nearDeath() {    
        if (medkitToRun == null) medkitToRun = new ArrayList<Item>();
        if (drive!= null && Triple.distanceInSpace(drive, bot.getMemory().getAgentLocation()) < 80) drive = null;
        
        // Otestuj zdravi agenta
    	if (bot.getMemory().getAgentHealth() > health_level) {
            return false;
        }
        else {  // Malo zdravi
            medkitToRun.clear();
            // zkus jestli nevidis medkit
            log.severe("I'am near death.");
            if (bot.getMemory().getSeeAnyHealth()) {
                log.info("I see any MEDKIT!");
                medkitToRun.add(bot.getMemory().getSeeHealth());
            }
            else {
                // najdi nejaky blizky 
                medkitToRun = bot.getMap().nearestHealth(25, 2);
                log.info("Try to choose nearest MEDKIT.");
            }
            return true;
        }
    }
   
    /**
     * v dohledu je nejaky jiny agent
     * @return
     */
    public boolean sense_seeTarget() {
        if  (bot.getMemory().getSeeAnyEnemy()) {
            enemy = bot.getMemory().getSeeEnemy();
            bot.getBody().turnToLocation(enemy.location);
        }
        else if (bot.getMemory().isShooting()) {
            log.info("Enemy runs away: stop shooting.");
            bot.getBody().stopShoot();
        }
        return bot.getMemory().getSeeAnyEnemy();
    }
    
    /**
     * test vhodnosti vyberu zbrane pro danou vzdalenost nepritele
     */
    public boolean sense_hasBetterWeapon() {
        Triple botLoc = bot.getMemory().getAgentLocation();
        
        //enemy = bot.getMemory().getSeeEnemy();
        if (enemy == null || enemy.location == null) return false;
    	AddWeapon candidate = bot.getMemory().getBetterWeapon(botLoc, enemy.location);
    	if (candidate != null) return true;
    	else return false;
    }
    
    /**
     * otestuje zdali agenta nekdo strelil, popripade nekdo strili do uhlu ve kterem se agent vyskytuje
     */
    public boolean sense_isAttacked(){
          if (bot.getMemory().isBeingDamaged()) return true;  
          else { 
            enemy = bot.getMemory().getSeeEnemy(); // pokud vydis nejakeho nepritele testuj zda nestrili na tebe     
            if (enemy != null ) {// vidim nepritele
                if (criticalAngle(enemy.location, enemy.getPlayerRotation(),bot.getMemory().getAgentLocation())) {// jsem v uhlu strelby
                log.info("I'm under attack.");
                return true;
            } else return false;}
            else return false;
          }
    }
    
    /**
     *  na obzoru neni zadny agent
     */
    public boolean sense_notSeeTarget() {
        if (bot.getMemory().getSeeAnyEnemy()) {
            enemy = bot.getMemory().getSeeEnemy();
            return false;
        }
        if (bot.getMemory().isShooting()) {
            log.info("Enemy runs away");
            bot.getBody().stopShoot();
        }
        return true;
    }
    
    /**
     * Agent je pod utokem -> otoci se smerem k utocnikovi a vysle ctyri paprsky 
     * - dva vpravo a dva vlevo 90 a 60 stupnu
     * - pokud paprsek 60 narazi na prekazku a paprsek 90 ne Agent ma pobliz cover do ktereho se muze schovat
     * - paprsek 60 staci aby narazil blize nez paprsek 90 (v zavislosti na vzdalenosti utocnika)
     */
    public boolean sense_hasNearCover(){
        log.info("Searching for cover.");
        // inicializace raytracu
        if (init) {
//            traces.botInit();
            init = false;
        }
        
        Triple cover, //pozice pomyslne bedny
               free_position, // misto, kde se lze ukryt
               BotLoc = bot.getMemory().getAgentLocation(), // pozice bota
               enemy_position = new Triple(1,0,0); // pozice nepritele
        
        // musi se merit, kdyz vidim nepritele
        if (enemy != null) enemy_position = enemy.location;
        else {
            log.severe("Bug - can hide but not see enemy!");
            return false;
        }
        // a jsem k nemu natocen
        bot.getBody().turnToLocation(enemy_position);
        
        // vysledky raytracu
        Map<Integer, AutoTraceRay> rays = traces.getTraceSnapshot();
        for (AutoTraceRay ray : rays.values()) {
            // log them
            log.info(ray.toString());
        }
        
        // vzdalenost nepritele
        double enemy_distance = Triple.vectorSize(Triple.subtract(BotLoc,enemy_position));
        
        //musi hitnout alespon ray(3) - jinak jdou paprsky dal nez 1000 => cover neni
        if (rays.get(3).result) {
            cover = new Triple(rays.get(Ray.RIGHT30_1000.getId()).hitLocation); 
            log.info("Cover at: ["+cover.x+","+cover.y+","+cover.z+"]");
            // misto kam si muzu stoupnout
            if (rays.get(4).result) free_position = Triple.subtract(new Triple(rays.get(Ray.RIGHT90_1000.getId()).hitLocation),BotLoc);
            else free_position = new Triple(0,-1000,0);
            log.info("Free position at: ["+free_position.x+","+free_position.y+","+free_position.z+"]");
            
            //pozice kde uz budu schovan
            hide_position = Triple.multiplyByNumber(
                                Triple.subtract(cover, enemy_position),
                                enemy_distance/(enemy_distance - Triple.subtract(cover, BotLoc).vectorSize()/2));
            log.info("Hide position at: ["+hide_position.x+","+hide_position.y+","+hide_position.z+"]");
            
            // otestuj jestli se za bednu vejdu ...
            if (free_position.vectorSize() > Triple.subtract(hide_position,BotLoc).vectorSize()) return true;
        }
        
        if (rays.get(1).result) {
            //pozice prekazky za kterou se schovat
            cover = new Triple(rays.get(Ray.LEFT30_1000.getId()).hitLocation);
            log.info("Cover at: ["+cover.x+","+cover.y+","+cover.z+"]");
            // misto kam si muzu stoupnout
            if (rays.get(2).result) free_position = new Triple(rays.get(Ray.LEFT90_1000.getId()).hitLocation);
            else free_position = new Triple(0,1000,0);
            log.info("Free position at: ["+free_position.x+","+free_position.y+","+free_position.z+"]");
            
            // pozice, kde uz budu schovan
            hide_position = Triple.multiplyByNumber(
                                Triple.subtract(cover, enemy_position),
                                enemy_distance/(enemy_distance - Triple.subtract(cover, BotLoc).vectorSize()/2));
        
            // otestuj jestli se za bednu vejdu ...
            if (free_position.vectorSize() > Triple.subtract(hide_position,BotLoc).vectorSize()) return true;
        }
        
        return false;
    }
    
    /**
     * abychom nestrileli vecne a setrili si naboje
     * @return
     */
    public boolean sense_notShooting(){
        return !bot.getMemory().isShooting();
    }
    
    /**
     * tahle funkce je tu navic, kdybychom z KeepOutBota chteli udelat Huntera, staci pouzit sposhPlan, ktery je v package testing
     * @return
     */
    public boolean sense_notKillEnemy(){
        return enemy != null;
    }
    
    /**
     *  Always can BOOST :o)
     */
    public boolean sense_canBoost(){
        return true;
    }    
    
    @Override
    public boolean sense_fail() {
        return false;
    }
    
    @Override
    public boolean sense_succeed() {
        return true;
    }
    
    /**
     * vybere ze seznamu medikamentu ten prvni a pro ten si dojde, kdyby nekde uvizl po 100 cyklech to zabali
     * @return
     */
    public boolean action_findMeds() {
        while (drive == null || 
               (!medkitToRun.isEmpty() &&
               Triple.distanceInSpace(drive, bot.getMemory().getAgentLocation())<80) || find_med > 100) {
            drive = medkitToRun.remove(0).location;
            find_med = 0;
        }        
        find_med++;
        log.info("Running for: MEDKIT "+drive);
        bot.getMap().safeRunToLocation(drive);
        return true;
    }
     
    /**
     * prezbrojeni na effektivnejsi zbran
     * @return
     */
    public boolean action_rearm() {
        log.info("Have better weapon: REARMING");
        AddWeapon weapon = bot.getMemory().getBetterWeapon(bot.getMemory().getSeeEnemy().location,
                                                           bot.getMemory().getAgentLocation());
        bot.getBody().changeWeapon(weapon);
        return true;
    }  
    /**
     * kdyz ma uhybat tak nahodne ve svem okoli zvoli bod a k nemu se vyda, bud jej dosahne a nebo po nejake dobe zvoli dalsi bod
     * @return
     */
    public boolean action_turnAndStrafe(){
        Triple BotLoc = bot.getMemory().getAgentLocation();
        BotLoc.z=0;
        if (!bot.getMemory().getSeeAnyEnemy()) bot.getBody().turnHorizontal(15);
        else bot.getBody().turnToLocation(bot.getMemory().getSeeEnemy().location);
        
        Triple face = Triple.rotationAsVectorUTUnits(bot.getMemory().getAgentRotation());
        if (direction != null) {
            MARK = new Triple(direction);
            direction = null;
        }
        else if (MARK == null || Triple.subtract(BotLoc, MARK).vectorSize() < 80 || strafe > 5) {
            MARK = Triple.add(BotLoc, new Triple(Math.signum(Math.random()-0.5)*(150 + Math.random()*300),
                                                 Math.signum(Math.random()-0.5)*(150 + Math.random()*300),
                                                 0));
            face = new Triple(-face.x, -face.y, -face.z);
            strafe = 0;
        }
        else strafe++;
        log.info("MARK at: ["+MARK.x+","+MARK.y+","+MARK.z+"]");
        
        if (!bot.getMemory().getSeeAnyEnemy()) bot.getBody().strafeToLocation(MARK, face);
        else bot.getBody().strafeToLocation(MARK,bot.getMemory().getSeeEnemy().location);
        return true;
    }
    
    /**
     * kdyz existuje kryt, tak se sakra schovej
     * @return
     */
    public boolean action_hide(){
        if (enemy!=null) bot.getBody().strafeToLocation(hide_position,enemy.location);
        return true;
    }
    
    /**
     * kdyz muzes nekoho strelit neni duvod to neudelat
     * @return
     */
    public boolean action_shootTarget(){
        bot.getBody().shoot(enemy);
        return true;
    }
    
    /**
     * a tahle funkce z nej udela huntera
     * @return
     */
    public boolean action_huntEnemy(){
        if (Triple.distanceInSpace(bot.getMemory().getAgentLocation(), enemy.location)>150) 
            bot.getBody().runToLocation(enemy.location);
        else {
            bot.getBody().turnHorizontal(30);
            //enemy = null;
        }
        
        return true;
    }
    
    /**
     * A kdyz uz neni do ceho pichnout, tak se mrkni po nejakych tech vecech k sezrani
     */
    public boolean action_lookAround(){
        double k;
        ArrayList<Weapon> weapons;
        ArrayList<Ammo> ammos;
        ArrayList<Armor> armors;
        ArrayList<Health> healths; 
        
        log.info("Looking around: "+look);
        ammos = bot.getMemory().getKnownAmmos();
        weapons = bot.getMemory().getKnownWeapons();
        armors = bot.getMemory().getKnownArmors();
        healths = bot.getMemory().getKnownHealths();
        
        if (direction == null) {
            bot.getMemory().getAgentAmmo();
            if (ammos!=null && (!bot.getMemory().hasLoadedWeapon() || bot.getMemory().getAgentAmmo()<15)) {
                log.info("Running for Ammo");
                k = 1/Math.pow(2, bot.getMemory().numberOfWeapons());
                for(Ammo ammo: ammos) {
                    if (Math.random()> k) {
                        k *= 2.1;
                        continue;
                    }
                    if (bot.getMemory().isAmmoSuitable(ammo)) {
                        direction = new Triple(ammo.location);
                        break;
                    }
                }    
            }
            else if (weapons != null && (bot.getMemory().numberOfLoadedWeapons() < 4)) {
                log.info("Running for Weapon");
                k = 1/Math.pow(2, weapons.size()-bot.getMemory().numberOfWeapons());
                for(Weapon weapon: weapons) {
                    if (Math.random()> k) {
                        k*=2.1;
                        continue;
                    }
                    if (!bot.getMemory().hasWeaponOfType(weapon.weaponType)) {
                        direction = new Triple(weapon.location);
                        break;
                    }
                }
            }
            else if (armors != null && (bot.getMemory().getAgentArmor() < 50)) {
                log.info("Running for Armor");
                k = 1/Math.pow(2, armors.size());
                for(Armor armor: armors) {
                    if (Math.random()> k) {
                        k *= 2.1;
                        continue;
                    } 
                    if (bot.getMemory().getAgentArmor()<armor.strenght) {
                        direction =  new Triple(armor.location);
                        break;
                    }
                }
            } else {
                if (healths != null) {
                    k = 1/Math.pow(2, healths.size());
                    for(Health health:healths){
                        if (Math.random()> k) {
                            k *= 2.1;
                            continue;
                        }
                        if (health.boostable) {
                            direction = new Triple(health.location);
                            break;
                        }
                    }
                }
            }
            look = 0;
            return true;
        } else {
            look++;
            bot.getMap().safeRunToLocation(direction);
            if (Triple.distanceInSpace(bot.getMemory().getAgentLocation(),direction) < 50 || 
                look>100) direction = null;
        }
        return true;
    }
    
    public boolean action_doNothing() {        
    	return true;
    }
    
    /** Nechtejte vedet co tohle dela, ja sam to nevim */
    private boolean criticalAngle(Triple enemy, Triple enemy_face, Triple my_pos){
        enemy_face = Triple.rotationAsVectorUTUnits(enemy_face); // prevedeni neznamych jednotek rotace na jeste neznamejsi
        Triple ab = Triple.subtract(enemy, my_pos); // rozdil v pozicich me a bota
        ab.z=0; // vynulovani urovni - rotace nema zetovou slozku, takze ji musime zrusit i u vzajemnych pozic :o( nebude to fungovat tak pekne
        double angle = Triple.angle(ab, enemy_face); // uhel mezi vektorem nepritel ja a jeho rotaci
        double distance = ab.vectorSize(); // vzdalenost od nepritele
        
        if ((Math.PI-angle)*distance < 80) return true; // empiricky zjistena hodnota - ja uz bych se bal :o)
        else return false;
    }
}
